<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/
@set_time_limit(0);
ignore_user_abort(1);

// #############################################################################
if ($_REQUEST['action'] == 'maintenance' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbmail_maintenance']);

	$mailinglists = array();
	foreach (VBMAIL::$cache['mailinglist'] as $mailinglistid => $mailinglist)
	{
		// Index by categoryid
		$mailinglists[$mailinglistid] = $mailinglist['title'];
	}

	// Set size
	$size = count($mailinglists);
	$size = ($size > 10 ? 10 : ($size < 5 ? 5 : $size));

	print_form_header('vbmail', 'maintenance');
	construct_hidden_code('action', 'unsubscribe');
	print_table_header($vbphrase['dbtech_vbmail_unsubscribe_users'], 2, 0);
	print_description_row($vbphrase['dbtech_vbmail_unsubscribe_users_descr']);
	print_membergroup_row($vbphrase['dbtech_vbmail_unsubscribe_usergroups'], 'usergroups', 2);
	print_select_row($vbphrase['dbtech_vbmail_unsubscribe_mailinglists'], 'mailinglists[]', $mailinglists, '', false, $size, true);
	print_yes_no_row($vbphrase['dbtech_vbmail_are_you_sure_unsubscribe'], 'dounsubscribe', 0);
	print_submit_row($vbphrase['dbtech_vbmail_unsubscribe_users']);
}

// #############################################################################
if ($_POST['action'] == 'unsubscribe')
{
	print_cp_header($vbphrase['dbtech_vbmail_maintenance']);

	$vbulletin->input->clean_array_gpc('p', array(
		'dounsubscribe' => TYPE_BOOL,
		'usergroups' 	=> TYPE_ARRAY_UINT,
		'mailinglists' 	=> TYPE_ARRAY_UINT,
	));

	if (!$vbulletin->GPC['dounsubscribe'])
	{
		// Nothing to do
		print_stop_message('nothing_to_do');
	}

	echo '<p>' . $vbphrase['dbtech_vbmail_unsubscribing_users'] . '</p>';

	$subscriptions = VBMAIL::$db->fetchAllObject('
		SELECT *
		FROM $dbtech_vbmail_subscription
		WHERE userid IN(
			SELECT userid
			FROM $user
			:whereUser
		)
			AND subscribed = 1
			:whereList
	', array(
		':whereUser' => (!empty($vbulletin->GPC['usergroups']) ? "WHERE usergroupid " . VBMAIL::$db->queryList($vbulletin->GPC['usergroups']) . " \r\n\t\t\t\tOR FIND_IN_SET(" . implode(", membergroupids) \r\n\t\t\t\tOR FIND_IN_SET(", $vbulletin->GPC['usergroups']) . ", membergroupids)" : ''),
		':whereList' => (!empty($vbulletin->GPC['mailinglists']) ? 'AND mailinglistid ' . VBMAIL::$db->queryList($vbulletin->GPC['mailinglists']) : ''),
	));
	while ($subscription = VBMAIL::$db->fetchCurrent())
	{
		// Save changes
		VBMAIL::$db->update('dbtech_vbmail_subscription', array(
			'subscribed' => 0,
		), 'WHERE userid = ' . intval($subscription['userid']) . ' AND mailinglistid = ' . intval($subscription['mailinglistid']));

		// We either subscribed or unsubscribed
		VBMAIL::$db->insert('dbtech_vbmail_subscriptionlog', array(
			'userid' 		=> $subscription['userid'],
			'mailinglistid' => $subscription['mailinglistid'],
			'dateline' 		=> TIMENOW,
			'subscribed' 	=> 0,
			'reason' 		=> 'unsubscribed_admin_mass',
		));

		if ($mailinglist = VBMAIL::$cache['mailinglist'][$subscription['mailinglistid']])
		{
			// init data manager
			$dm =& VBMAIL::initDataManager('Mailinglist', $vbulletin, ERRTYPE_SILENT);
				$dm->set_existing($mailinglist);
				$dm->set('unsubscriptions', 'unsubscriptions + 1', false);
			$dm->save();
		}
	}

	define('CP_REDIRECT', 'vbmail.php?do=maintenance');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['users'], $vbphrase['dbtech_vbmail_unsubscribed']);
}

print_cp_footer();